// Decompiled by Jad v1.5.8g. Copyright 2001 Pavel Kouznetsov.
// Jad home page: http://www.kpdus.com/jad.html
// Decompiler options: packimports(3) braces deadcode 

package net.minecraft.src;

import java.util.ArrayList;


// Referenced classes of package net.minecraft.src:
//            TileEntity, IInventory, ItemStack, NBTTagCompound, 
//            NBTTagList, World, Item, BlockShrine, 
//            ShrineRecipes, Block, Material, ModLoader, 
//            EntityPlayer

public class TileEntityShrine extends TileEntity
    implements IInventory
{

    public TileEntityShrine()
    {
        furnaceItemStacks = new ItemStack[2];
        waveCount = 0;
        time = 0;
        furnaceCookTime = 0;
    }

    public int getSizeInventory()
    {
        return furnaceItemStacks.length;
    }

    public ItemStack getStackInSlot(int i)
    {
        return furnaceItemStacks[i];
    }

    public ItemStack decrStackSize(int i, int j)
    {
        if(furnaceItemStacks[i] != null)
        {
            if(furnaceItemStacks[i].stackSize <= j)
            {
                ItemStack itemstack = furnaceItemStacks[i];
                furnaceItemStacks[i] = null;
                return itemstack;
            }
            ItemStack itemstack1 = furnaceItemStacks[i].splitStack(j);
            if(furnaceItemStacks[i].stackSize == 0)
            {
                furnaceItemStacks[i] = null;
            }
            return itemstack1;
        } else
        {
            return null;
        }
    }

    public void setInventorySlotContents(int i, ItemStack itemstack)
    {
        furnaceItemStacks[i] = itemstack;
        if(itemstack != null && itemstack.stackSize > getInventoryStackLimit())
        {
            itemstack.stackSize = getInventoryStackLimit();
        }
    }

    public String getInvName()
    {
        return "Shrine";
    }

    public void readFromNBT(NBTTagCompound nbttagcompound)
    {
        super.readFromNBT(nbttagcompound);
        NBTTagList nbttaglist = nbttagcompound.getTagList("Items");
        furnaceItemStacks = new ItemStack[getSizeInventory()];
        for(int i = 0; i < nbttaglist.tagCount(); i++)
        {
            NBTTagCompound nbttagcompound1 = (NBTTagCompound)nbttaglist.tagAt(i);
            byte byte0 = nbttagcompound1.getByte("Slot");
            if(byte0 >= 0 && byte0 < furnaceItemStacks.length)
            {
                furnaceItemStacks[byte0] = new ItemStack(nbttagcompound1);
            }
        }

        waveCount = nbttagcompound.getShort("BurnTime");
        furnaceCookTime = nbttagcompound.getShort("CookTime");
        time = nbttagcompound.getShort("3rdTime");
        health = nbttagcompound.getShort("Health");
    }

    public void writeToNBT(NBTTagCompound nbttagcompound)
    {
        super.writeToNBT(nbttagcompound);
        nbttagcompound.setShort("BurnTime", (short)waveCount);
        nbttagcompound.setShort("CookTime", (short)furnaceCookTime);
        nbttagcompound.setShort("3rdTime", (short)time);
        nbttagcompound.setShort("Health", (short)health);
        NBTTagList nbttaglist = new NBTTagList();
        for(int i = 0; i < furnaceItemStacks.length; i++)
        {
            if(furnaceItemStacks[i] != null)
            {
                NBTTagCompound nbttagcompound1 = new NBTTagCompound();
                nbttagcompound1.setByte("Slot", (byte)i);
                furnaceItemStacks[i].writeToNBT(nbttagcompound1);
                nbttaglist.setTag(nbttagcompound1);
            }
        }

        nbttagcompound.setTag("Items", nbttaglist);
    }

    public int getInventoryStackLimit()
    {
        return 64;
    }

    public void updateEntity()
    {
    	if (health>100)
    	{
    		health=100;
    	}
    	
        if(worldObj.singleplayerWorld)
        {
        	return;
        }

        ticked=true;
        generaltimer++;
        if (generaltimer%1200==0)
    	{
        	if (worldObj.isDaytime())
        	{
        		health+=waveCount;
        	}
        	else
        	{
        		if (waveSpawner!=null && !waveSpawner.done)
        		{
	        		health--;
	        		mod_Mine4Dead.sendString("Defeat the Wave, "+waveSpawner.countAll()+" mobs remaining ! Shrine HP: "+health+"%");
        		}
        	}
    	}
        
        if (canPurify())
        {
        	if (worldObj.isDaytime())
        	{
        		furnaceCookTime+=5;
        	}
        	else
        	{
        		furnaceCookTime++;
        	}
        	if (furnaceCookTime>=getPurificationTime())
        	{
        		furnaceCookTime=0;
        		purify();
        	}
        }
        
        if (lastClicker != null)
        {
        	if (lastClicker.health < 20 && canInteractWith(lastClicker))
        	{
        		healTimer++;
        		if (worldObj.isDaytime())
            	{
        			healTimer++;
            	}
        		if (healTimer>=lastClicker.health*15)
        		{
        			lastClicker.heal(1);
        			healTimer=0;
        			displayHeartsOnHealTarget();
        		}
        	}
        	else
        	{
        		lastClicker=null;
        		healTimer=0;
        	}
        }
        
        if (mod_Mine4Dead.shrine==null)
        {
        	mod_Mine4Dead.shrine=this;
        }
        
        if (waveSpawned)
        {
        	if (worldObj.rand.nextInt(10)==0)
        	{
        		waveSpawner.update();
        	}
        	if (waveSpawner.done)
        	{
        		waveSpawned=false;
        		time=-1200;
        		mod_Mine4Dead.score(20*waveCount);
        		mod_Mine4Dead.sendString("WAVE "+waveCount+" DEFEATED! Current Score: "+mod_Mine4Dead.score);
        	}
        }
        else
        {
        	time+=1;
	        int maxTime = 1200*mod_Mine4Dead.dayMin;
			if (waveCount==0)
			{
				maxTime =1200*mod_Mine4Dead.prepMin;
			}
			if (time > maxTime+1200)
			{
				waveCount++;
				WaveSpawner.spawnWave(this);
				waveSpawned=true;
			}
        }
    }
    
    public void damage(int d)
    {
    	health-=d;
    	if (health<=0)
    	{
    		mod_Mine4Dead.triggerGameOver();
    		return;
    	}
    	mod_Mine4Dead.sendString("The shrine is under attack! HP: "+health+"%");
    }
    
    public boolean heal()
    {
    	if (health==100)
    	{
    		return false;
    	}
    	health+=3;
    	if (health>100)
    	{
    		health=100;
    	}
    	mod_Mine4Dead.sendString("Shrine repaired to "+health+"% HP");
    	return true;
    }
    
    public void displayHeartsOnHealTarget()
    {
        for(int i = 0; i < 7; i++)
        {
            double d = worldObj.rand.nextGaussian() * 0.02D;
            double d1 = worldObj.rand.nextGaussian() * 0.02D;
            double d2 = worldObj.rand.nextGaussian() * 0.02D;
            worldObj.spawnParticle("heart", (lastClicker.posX + (double)(worldObj.rand.nextFloat() * lastClicker.width * 2.0F)) - (double)lastClicker.width, lastClicker.posY + 0.5D + (double)(worldObj.rand.nextFloat() * lastClicker.height), (lastClicker.posZ + (double)(worldObj.rand.nextFloat() * lastClicker.width * 2.0F)) - (double)lastClicker.width, d, d1, d2);
        }

    }
    
    public void clickedBy(EntityPlayer player)
    {
    	if (lastClicker!=null && lastClicker!=player)
    	{
    		healTimer-=100;
    	}
    	lastClicker=player;
    }

    private boolean canPurify()
    {
        if(furnaceItemStacks[1] == null)
        {
            return false;
        }
        if(furnaceItemStacks[1].itemID != mod_Mine4Dead.darkEnergy.shiftedIndex &&
        		furnaceItemStacks[1].itemID != mod_Mine4Dead.darkDiamond.shiftedIndex)
        {
            return false;
        }
        if (furnaceItemStacks[0] != null)
        {
	        if(furnaceItemStacks[1].itemID == mod_Mine4Dead.darkEnergy.shiftedIndex
	        		&& furnaceItemStacks[0].itemID != mod_Mine4Dead.lightEnergy.shiftedIndex ||
	        		furnaceItemStacks[0].stackSize == furnaceItemStacks[0].getMaxStackSize())
	        {
	            return false;
	        }
	        if(furnaceItemStacks[1].itemID == mod_Mine4Dead.darkDiamond.shiftedIndex)
	        {
	            return false;
	        }
        }
        return true;
    }
    
    private int getPurificationTime()
    {
    	if(furnaceItemStacks[1].itemID == mod_Mine4Dead.darkEnergy.shiftedIndex)
    	{
    		return purificationTime;
    	}
    	else
    	{
    		return purificationTime*8;
    	}
    }
    private static int purificationTime=185*5;

    public void purify()
    {
        if (furnaceItemStacks[0]!=null)
        {
        	furnaceItemStacks[0].stackSize++;
        }
        else
        {
        	if(furnaceItemStacks[1].itemID == mod_Mine4Dead.darkEnergy.shiftedIndex)
        	{
        		furnaceItemStacks[0] = new ItemStack(mod_Mine4Dead.lightEnergy);
        	}
        	else
        	{
        		furnaceItemStacks[0] = new ItemStack(mod_Mine4Dead.lightDiamond);
        	}
        }
        furnaceItemStacks[1].stackSize--;
        if (furnaceItemStacks[1].stackSize <= 0)
        {
        	furnaceItemStacks[1]=null;
        }
        onInventoryChanged();
    }

    public boolean canInteractWith(EntityPlayer entityplayer)
    {
        if(worldObj.getBlockTileEntity(xCoord, yCoord, zCoord) != this)
        {
            return false;
        }
        return entityplayer.getDistanceSq((double)xCoord + 0.5D, (double)yCoord + 0.5D, (double)zCoord + 0.5D) <= (double)MathHelper.sqrt_double(22D);
    }
    
    public boolean teleportMobHere(int i, int j, int k)
    {
    	if (waveSpawner==null)
    	{
    		return false;
    	}
    	else
    	{
    		return waveSpawner.teleportMobHere(i,j,k);
    	}
    }

    private ItemStack furnaceItemStacks[];
    public int waveCount;
    public int time;
    public int furnaceCookTime;
    public EntityPlayer lastClicker = null;
    public int healTimer = 0;
    public boolean waveSpawned = false;
    public WaveSpawner waveSpawner = null;
    public boolean ticked = false;
    public int health = 100;
    public int generaltimer = 0;
}
